<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register - Musical Chairs</title>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="style.css">
</head>
<body class="bg-gradient-to-br from-gray-900 to-black text-white font-sans flex items-center justify-center min-h-screen p-4">
    <div class="bg-gray-800 p-8 rounded-lg shadow-lg max-w-md w-full border border-gray-700">
        <h1 class="text-3xl font-bold text-cyan-400 mb-6 text-center">📝 Register</h1>
        <form action="YOUR_PHP_OR_JAVA_REGISTER_ENDPOINT" method="POST" class="space-y-4">
            <div>
                <label for="username" class="block text-sm font-medium text-gray-300 text-left mb-1">Username</label>
                <input type="text" id="username" name="username" required
                       class="w-full px-4 py-2 rounded-md bg-gray-700 border border-gray-600 focus:outline-none focus:ring-2 focus:ring-cyan-500 text-white placeholder-gray-400">
            </div>
            <div>
                <label for="password" class="block text-sm font-medium text-gray-300 text-left mb-1">Password</label>
                <input type="password" id="password" name="password" required
                       class="w-full px-4 py-2 rounded-md bg-gray-700 border border-gray-600 focus:outline-none focus:ring-2 focus:ring-cyan-500 text-white placeholder-gray-400">
            </div>
            <div>
                <label for="confirm_password" class="block text-sm font-medium text-gray-300 text-left mb-1">Confirm Password</label>
                <input type="password" id="confirm_password" name="confirm_password" required
                       class="w-full px-4 py-2 rounded-md bg-gray-700 border border-gray-600 focus:outline-none focus:ring-2 focus:ring-cyan-500 text-white placeholder-gray-400">
            </div>
            <button type="submit"
                    class="w-full bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded-md transition duration-300 ease-in-out transform hover:scale-105">
                Register
            </button>
        </form>
        <p class="mt-6 text-center text-gray-400 text-sm">
            Already have an account? <a href="login.php" class="text-cyan-400 hover:underline">Login here</a>
        </p>
        <p class="mt-4 text-center text-gray-500 text-xs">
            <a href="index.html" class="text-gray-500 hover:underline">Back to Game</a>
        </p>
    </div>
</body>
</html>
