<!DOCTYPE html>
<html>
<head>
  <title>Login</title>
  <script>
    async function loginUser(event) {
      event.preventDefault();
      const username = document.getElementById('username').value;
      const password = document.getElementById('password').value;

      const res = await fetch('/api/auth/login', {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify({ username, password })
      });

      if (res.ok) {
        const data = await res.json();
        window.location.href = data.redirect;
      } else {
        alert('Login failed. Check your credentials.');
      }
    }
  </script>
</head>
<body class="p-4 text-center">
  <h2>Login</h2>
  <form onsubmit="loginUser(event)">
    <input type="text" id="username" placeholder="Username" required><br><br>
    <input type="password" id="password" placeholder="Password" required><br><br>
    <button type="submit">Login</button>
  </form>
</body>
</html>
