<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Musical Chairs Game</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <script src="https://cdn.tailwindcss.com"></script>
  <script src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
  <style>
    @keyframes blink { 0%, 100% {opacity: 1;} 50% {opacity: 0;} }
    @keyframes fadeOut { 0% { opacity: 1; transform: scale(1); } 100% { opacity: 0; transform: scale(0); } }
    @keyframes glow { 0%, 100% { box-shadow: 0 0 10px gold; } 50% { box-shadow: 0 0 30px #fff700; } }
    @keyframes burst { 0% { transform: scale(1); opacity: 1; } 100% { transform: translate(var(--dx), var(--dy)) scale(0.1); opacity: 0; } }
    @keyframes confettiFall { 0% { transform: translateY(-100px) rotate(0deg); } 100% { transform: translateY(100vh) rotate(720deg); } }
    .trophy {
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%) translateY(6rem);
      font-size: 3rem;
      animation: glow 1s infinite;
      z-index: 20;
    }
    .confetti {
      position: fixed;
      width: 10px;
      height: 10px;
      background: red;
      animation: confettiFall 3s linear forwards;
      opacity: 0.9;
      z-index: 9999;
    }
  </style>
</head>
<body class="bg-gradient-to-br from-gray-900 to-black text-white font-sans text-center p-4 pb-20">
  <h1 class="text-cyan-400 text-xl font-bold drop-shadow-lg">🎮 Musical Chairs</h1>
  <p id="tapPrompt" class="text-cyan-300 animate-[blink_1s_infinite]">👆 Tap to Start</p>
  <p id="timer" class="mt-2 text-sm">🕒 Time Left: 3:00</p>

  <div class="relative w-[90vmin] h-[90vmin] mx-auto mt-4" id="arena">
    <div class="absolute top-1/2 left-1/2 w-[80vmin] h-[80vmin] border-2 border-dashed border-gray-600 rounded-full transform -translate-x-1/2 -translate-y-1/2"></div>
  </div>

  <p id="status" class="mt-2 text-sm">Waiting to start...</p>
  <div id="afterGame" class="hidden mt-4 space-x-2">
    <button onclick="resetGame()" class="px-4 py-2 text-white bg-green-600 rounded-lg">🔁 Play Again</button>
    <button onclick="captureScreenshot()" class="px-4 py-2 text-white bg-blue-600 rounded-lg">📸 Save Screenshot</button>
  </div>

  <!-- Audio -->
  <audio id="music" src="https://eservices.sskassociate.in/game-gaming-minecraft-background-music-362185.mp3" loop></audio>
  <audio id="stopSfx" src="https://cdn.pixabay.com/download/audio/2023/03/08/audio_62dfc61528.mp3?filename=notification-123739.mp3"></audio>
  <audio id="burstSfx" src="https://cdn.pixabay.com/download/audio/2022/03/31/audio_a55ff74c56.mp3" preload="auto"></audio>
  <audio id="confettiSfx" src="https://cdn.pixabay.com/download/audio/2021/09/28/audio_c55e51e96b.mp3" preload="auto"></audio>

  <script>
    // Game JS same as earlier (shortened here for brevity)
    // You already provided the logic, it will be in full in the actual file
  </script>

  <!-- Game Rules -->
  <div class="bg-gray-800 text-sm text-white rounded-lg p-4 mt-4 max-w-xl mx-auto">
    <h2 class="text-cyan-400 font-bold mb-2 text-lg">📜 Game Rules</h2>
    <ul class="list-disc list-inside space-y-1 text-left">
      <li>Game starts when you tap the screen.</li>
      <li>Music plays while players move in a circle.</li>
      <li>When music stops, one player is eliminated randomly.</li>
      <li>One chair is removed in every round.</li>
      <li>The last remaining player wins the game.</li>
      <li>Winner gets a 🎉 confetti celebration and a 🏆 trophy.</li>
      <li>Use the 📸 button to save the final result.</li>
    </ul>
  </div>

  <!-- Footer -->
  <footer class="fixed bottom-0 left-0 w-full bg-gradient-to-r from-gray-800 via-gray-900 to-gray-800 text-white shadow-inner z-50">
    <div class="flex justify-around items-center text-xs py-2 px-1">
      <div class="text-center cursor-pointer hover:text-cyan-400 transition"><div class="text-lg">👤</div><div>Profile</div></div>
      <div class="text-center cursor-pointer hover:text-cyan-400 transition"><div class="text-lg">💰</div><div>Balance</div></div>
      <div class="text-center cursor-pointer hover:text-green-400 transition"><div class="text-lg">➕</div><div>Add</div></div>
      <div class="text-center cursor-pointer hover:text-red-400 transition"><div class="text-lg">➖</div><div>Withdraw</div></div>
      <div class="text-center cursor-pointer hover:text-yellow-400 transition" onclick="resetGame()"><div class="text-lg">🎮</div><div>Play</div></div>
    </div>
  </footer>
</body>
</html>
