<script>
window.onload = function () {
  const players = document.querySelectorAll('.player');
  const chairs = Array.from(document.querySelectorAll('.chair'));
  const music = document.getElementById('music');
  const stopSfx = document.getElementById('stopSfx');
  const burstSfx = document.getElementById('burstSfx');
  const confettiSfx = document.getElementById('confettiSfx');
  const timer = document.getElementById('timer');
  const status = document.getElementById('status');
  const tapPrompt = document.getElementById('tapPrompt');

  let timeLeft = 180;
  let gameOver = false;
  let angleOffset = 0;

  function movePlayers() {
    const R = 40;
    angleOffset += 1;
    const active = [...players].filter(p => !p.classList.contains('hidden'));
    active.forEach((p, i) => {
      const angle = 2 * Math.PI * i / active.length + angleOffset * Math.PI / 180;
      const x = 50 + R * Math.cos(angle);
      const y = 50 + R * Math.sin(angle);
      p.style.left = `${x}%`;
      p.style.top = `${y}%`;
    });
  }

  function placeChairs() {
    const visibleChairs = chairs.filter(c => !c.classList.contains('hidden'));
    const R = 20 + (visibleChairs.length * 2); // Dynamically shrink radius
    visibleChairs.forEach((chair, i) => {
      const angle = 2 * Math.PI * i / visibleChairs.length;
      const x = 50 + R * Math.cos(angle);
      const y = 50 + R * Math.sin(angle);
      chair.style.left = `${x}%`;
      chair.style.top = `${y}%`;
    });
  }

  function startTimer() {
    const interval = setInterval(() => {
      if (--timeLeft <= 0 || gameOver) {
        clearInterval(interval);
        endGame();
      }
      const m = Math.floor(timeLeft / 60);
      const s = String(timeLeft % 60).padStart(2, '0');
      timer.textContent = `🕒 Time Left: ${m}:${s}`;
    }, 1000);
  }

  function loopGame() {
    if (gameOver) return;
    music.play();
    status.textContent = "🎶 Music Playing...";
    const rotator = setInterval(movePlayers, 30);

    setTimeout(() => {
      clearInterval(rotator);
      music.pause();
      stopSfx.play();
      status.textContent = "⛔ Music Stopped! Eliminating...";
      eliminateOne();

      const alive = [...players].filter(p => !p.classList.contains('hidden'));
      if (alive.length <= 1) {
        gameOver = true;
        endGame();
      } else {
        setTimeout(loopGame, 10); // Small delay before next round
      }
    }, 10000);
  }

  function eliminateOne() {
    // Eliminate one player
    const alivePlayers = [...players].filter(p => !p.classList.contains('hidden'));
    const unluckyPlayer = alivePlayers[Math.floor(Math.random() * alivePlayers.length)];
    const rect = unluckyPlayer.getBoundingClientRect();
    particleBurst(rect.left + rect.width / 2, rect.top + rect.height / 2);
    unluckyPlayer.classList.add('hidden');

    // Eliminate one chair
    const visibleChairs = chairs.filter(c => !c.classList.contains('hidden'));
    if (visibleChairs.length > 0) {
      const unluckyChair = visibleChairs[Math.floor(Math.random() * visibleChairs.length)];
      unluckyChair.classList.add('hidden');
    }

    // Re-align remaining chairs
    placeChairs();
  }

  function endGame() {
    const winner = [...players].find(p => !p.classList.contains('hidden'));
    const name = winner ? winner.dataset.name : "No one";
    if (winner) {
      winner.classList.add('winner-center');
      winner.style.left = '50%';
      winner.style.top = '50%';
    }
    status.innerHTML = `🏁 Game Over! 🏆 Winner: <strong style="color:gold">${name}</strong>`;
    timer.textContent = "🛑 Game Ended";
    launchConfetti();
    document.getElementById('afterGame').style.display = 'block';
  }

  function resetGame() {
    document.querySelectorAll('.player, .chair').forEach(el => {
      el.classList.remove('hidden', 'winner-center');
      el.style.display = '';
    });
    timeLeft = 180;
    gameOver = false;
    angleOffset = 0;
    status.textContent = "⏳ Restarting...";
    timer.textContent = "🕒 Time Left: 3:00";
    setTimeout(() => {
      placeChairs();
      loopGame();
      startTimer();
    }, 1000);
  }

  function particleBurst(x, y) {
    burstSfx.play();
    for (let i = 0; i < 10; i++) {
      const p = document.createElement('div');
      p.className = 'particle';
      p.style.left = x + 'px';
      p.style.top = y + 'px';
      p.style.setProperty('--dx', (Math.random() * 100 - 50) + 'px');
      p.style.setProperty('--dy', (Math.random() * 100 - 50) + 'px');
      document.body.appendChild(p);
      setTimeout(() => p.remove(), 600);
    }
  }

  function launchConfetti() {
    confettiSfx.play();
    for (let i = 0; i < 50; i++) {
      const c = document.createElement('div');
      c.className = 'confetti';
      c.style.left = Math.random() * 100 + 'vw';
      c.style.backgroundColor = `hsl(${Math.random() * 360}, 100%, 50%)`;
      document.body.appendChild(c);
      setTimeout(() => c.remove(), 3000);
    }
  }

  // 🔘 Start Game on First Tap
  document.addEventListener('click', () => {
    if (gameOver) return;
    if (tapPrompt) tapPrompt.remove();
    let pre = 10;
    status.textContent = "⏳ Starting in 10 sec...";
    const countdown = setInterval(() => {
      pre--;
      if (pre <= 0) {
        clearInterval(countdown);
        status.textContent = "🎮 Game Started!";
        placeChairs();
        startTimer();
        loopGame();
      } else {
        status.textContent = `⏳ Starting in ${pre} sec...`;
      }
    }, 1000);
  }, { once: true });
};
</script>
